#pragma once

#include <stddef.h>
#include <stdint.h>

#include <enyx/cores_c/symbol_visibility.h>
#include <enyx/cores_c/data_stream/sink.h>
#include <enyx/cores_c/data_stream/source.h>
#include <enyx/cores_c/data_stream/metadata.h>

/**
 *  This structure contains the TCP related data
 */
struct enyx_tcp_metadata
{
    /// Metadata chain
    enyx_data_stream_metadata metadata;

    /// The TCP session id
    uint32_t session_id;

    /// The TCP message flags
    uint8_t flags;
};

/// Alias shortchut
typedef struct enyx_tcp_metadata enyx_tcp_metadata;

/**
 * TCP source callback to invoke when data to be decoded is available.
 *
 * @param data: The TCP data to decode
 * @param size: Data size
 * @param metadata: Metadata associated with passed data
 * @param opaque: Opaque pointer to TCP source
 */
ENYX_CORES_C_SYMBOL_VISIBILITY void
enyx_tcp_on_data(uint8_t const * data,
                 uint32_t size,
                 void const  * metadata,
                 void * opaque);

/**
 * Create a @p tcp_sink that send to @p data_sink
 *
 * @param tcp_sink The TCP sink to create
 * @param data_sink The sink of the TCP data
 * @return 0 on success, -1 on error (@b errno is set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY int
enyx_tcp_create_sink(enyx_data_stream_sink * tcp_sink,
                     enyx_data_stream_sink * data_sink);
