ENYX_CORES_NAMESPACE_BEGIN

namespace probes {

inline
probe::probe(hw::core const & core, id new_id, ::enyx_probes_ts_format ts_format)
    : core_(core)
    , probe_(::enyx_probes_probe_create(core_.handle(), new_id, ts_format))
{
    if (! probe_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to construct probe"};
}

inline
probe::probe(hw::core const & root, ::enyx_probes_probe * handle)
    : core_(root)
    , probe_(handle)
{
    if (! probe_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to construct probe"};
}

inline ::enyx_probes_probe *
probe::handle() noexcept
{
    return probe_.get();
}

inline ::enyx_probes_probe const *
probe::handle() const noexcept
{
    return probe_.get();
}

inline result<probe::id>
probe::get_id() const noexcept
{
    id probe_id;
    if (::enyx_probes_probe_get_id(handle(), &probe_id) < 0)
        return {std::error_code{errno, std::generic_category()}};

    return probe_id;
}

inline event_format
probe::get_event_format() const noexcept
{
    return *::enyx_probes_probe_get_event_format(handle());
}

inline std::string
probe::get_name() const noexcept
{
    return ::enyx_probes_probe_get_name(handle());
}

inline std::string
probe::get_collector_name() const noexcept
{
    return ::enyx_probes_probe_get_collector_name(handle());
}

inline bool
probe::is_enabled() const noexcept
{
    return ::enyx_probes_probe_is_enabled(handle());
}

inline result<void>
probe::enable() noexcept
{
    if (::enyx_probes_probe_enable(handle()) != 0)
        return {std::error_code{errno, std::generic_category()}};

    return {};
}

inline result<void>
probe::disable() noexcept
{
    if (::enyx_probes_probe_disable(handle()) != 0)
        return {std::error_code{errno, std::generic_category()}};

    return {};
}

inline result<std::size_t>
probe::get_drop_count() noexcept
{
    auto res = ::enyx_probes_probe_get_drop_count(handle());
    if (res < 0)
        return {std::error_code{errno, std::generic_category()}};

    return res;
}

inline result<std::size_t>
probe::get_packet_count() noexcept
{
    auto res = ::enyx_probes_probe_get_packet_count(handle());
    if (res < 0)
        return {std::error_code{errno, std::generic_category()}};

    return res;
}

inline std::ostream &
operator<<(std::ostream & out, probe const & p)
{
    out << "probe " << p.get_name();
    return out;
}

} /* namespace probes */

ENYX_CORES_NAMESPACE_END
