ENYX_CORES_NAMESPACE_BEGIN

namespace probes {

inline
mtg::mtg(hw::core const & root)
    : mtg_(::enyx_probes_mtg_create(root.handle()))
{
    if (! mtg_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to construct mtg"};
}

inline
mtg::mtg(enyx_probes_mtg * handle)
    : mtg_(handle)
{
    if (! mtg_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to construct mtg"};
}

inline ::enyx_probes_mtg *
mtg::handle() noexcept
{
    return mtg_.get();
}

inline ::enyx_probes_mtg const *
mtg::handle() const noexcept
{
    return mtg_.get();
}

inline result<ts_format>
mtg::get_ts_format() const noexcept
{
    ts_format format;
    if (::enyx_probes_mtg_get_ts_format(handle(), &format) < 0)
        return {std::error_code{errno, std::generic_category()}};

    return format;
}

inline std::ostream &
operator<<(std::ostream & out, mtg const & m)
{
    out << "mtg";
    return out;
}

} /* namespace probes */

ENYX_CORES_NAMESPACE_END
