"""Provide core content representation objects and tools to create cores using
jinja templates
"""
from .core import Core

from .register import Register
from .register import Argument, Config, Done, Return, Monitored
from .register import StrIndex, StrValue
from .register import PageCount, PageID, PageReady

from .variable import Bit, Hex, Int, Enum, Bool, IPAddress, MACAddress, Time
from .variable import String, Page, Command

from .xml_parser import core_from_xml

__all__ = [
    'Register',
    'Argument',
    'Config',
    'Done',
    'Return',
    'Monitored',
    'PageCount',
    'PageID',
    'PageReady',
    'StrIndex',
    'StrValue',
    'Bit',
    'Hex',
    'Int',
    'Enum',
    'Bool',
    'IPAddress',
    'MACAddress',
    'Time',
    'String',
    'Page',
    'Command',
    'Core',
    'core_from_xml',
]

__version__ = '4.0.7'
