ENYX_HW_NAMESPACE_BEGIN

inline
core_tree::core_tree(mmio const & mmio,
                     ::enyx_hw_core_tree * const tree)
    : mmio_(mmio), tree_(tree, &::enyx_hw_destroy_tree)
{
    if (tree_ == nullptr)
        throw std::system_error(errno, std::generic_category());
}

inline core
core_tree::get_root() const noexcept
{
    return {mmio_, ::enyx_hw_core_tree_get_root(handle()), tree_};
}

inline ::enyx_hw_core_tree *
core_tree::handle() noexcept
{
    return tree_.get();
}

inline ::enyx_hw_core_tree const *
core_tree::handle() const noexcept
{
    return tree_.get();
}

inline core::iterator
core_tree::begin() const noexcept
{
    return get_root().begin();
}

inline core::iterator
core_tree::end() const noexcept
{
    return get_root().end();
}

inline std::ostream &
operator<<(std::ostream & out, core_tree const & tree)
{
    std::stack<std::pair<core, size_t>> stack;
    stack.emplace(tree.get_root(), 0);

    while (!stack.empty()) {
        auto elem = stack.top();
        stack.pop();
        out << std::string(elem.second, '\t')
            << elem.first << std::endl;

        for (auto const & child: elem.first.get_children())
            stack.emplace(child, elem.second + 1);
    }
    return out;
}

inline core_tree
enumerate_cores(mmio & mmio)
{
    auto c_tree = enyx_hw_enumerate_cores(mmio.handle());
    if (c_tree == nullptr)
        throw std::system_error(errno, std::generic_category());
    return {mmio, c_tree};
}

ENYX_HW_NAMESPACE_END
