ENYX_HW_NAMESPACE_BEGIN

inline const properties
accelerator_descriptor::get_properties() const
{
    return {enyx_hw_accelerator_get_properties(handle())};
}

inline
accelerator_descriptor::accelerator_descriptor(
        enyx_hw_accelerator_descriptor const * descriptor)
    : descriptor_(descriptor, &enyx_hw_accelerator_put_descriptor)
{
    if (descriptor_ == nullptr)
        throw std::system_error{EINVAL, std::generic_category()};
}

inline result<product_version>
accelerator_descriptor::get_version() const noexcept
{
    product_version ret{};
    if (::enyx_hw_accelerator_get_version(handle(), &ret) < 0)
        return std::error_code{errno, std::generic_category()};
    return ret;
}

inline result<std::size_t>
accelerator_descriptor::count_users() const noexcept
{
    auto ret = ::enyx_hw_accelerator_count_users(handle());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};
    return ret;
}

inline result<void>
accelerator_descriptor::reset() const noexcept
{
    if (::enyx_hw_accelerator_reset(handle()) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline enyx_hw_accelerator_descriptor const *
accelerator_descriptor::handle() const noexcept
{
    return descriptor_.get();
}

inline std::vector<accelerator_descriptor>
enumerate_accelerators()
{
    auto accelerator_count = enyx_hw_count_accelerators();
    std::vector<enyx_hw_accelerator_descriptor const *> c_descriptors(accelerator_count);
    int ret = enyx_hw_enumerate_all_accelerators(c_descriptors.data(),
                                                 c_descriptors.size());
    if (ret < 0)
        return {};

    std::vector<accelerator_descriptor> vec;
    for (auto & c_descriptor : c_descriptors) {
        vec.emplace_back(c_descriptor);
        c_descriptor = nullptr;
    }

    return vec;
}

inline std::vector<accelerator_descriptor>
enumerate_accelerators(filter const & filter)
{
    auto accelerator_max = enyx_hw_count_accelerators();
    std::vector<enyx_hw_accelerator_descriptor const *> c_descriptors(accelerator_max);
    auto ret = enyx_hw_enumerate_accelerators(filter.handle(),
                                              c_descriptors.data(),
                                              c_descriptors.size());
    if (ret < 0)
        return {};

    std::vector<accelerator_descriptor> vec;
    for (auto & c_descriptor : c_descriptors) {
        if (c_descriptor == nullptr)
            break;
        vec.emplace_back(c_descriptor);
        c_descriptor = nullptr;
    }

    return vec;
}

ENYX_HW_NAMESPACE_END
